<?php

namespace App\Models;

use App\Models\Translations\QuestionCategoryTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class QuestionCategory extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name', 'slug'];
    }

    public function translations(): HasMany
    {
        return $this->hasMany(QuestionCategoryTranslation::class);
    }

    public function questions(): HasMany
    {
        return $this->hasMany(Question::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(QuestionCategoryTranslation::class)
            ->where('locale', config('app.locale'));
    }
}
