<?php

namespace App\Modules\Wishlist\Livewire\Wishlist;

use App\Modules\Wishlist\Contracts\WishlistInterface;
use App\Modules\Wishlist\Wishlist;
use Daylight\Core\Models\Product;
use Illuminate\View\View;
use Livewire\Component;

class AddToWishlist extends Component
{
    public Product $product;

    public bool $absolute = false;

    public bool $isActive = false;

    public function mount()
    {
        $this->isActive = $this->wishlist()->contents()->contains($this->product);
    }

    public function wishlist(): Wishlist
    {
        return app(WishlistInterface::class);
    }

    public function toggle(): void
    {
        if ($this->isActive) {
            $this->wishlist()->remove($this->product);
            $this->isActive = false;
        } else {
            $this->wishlist()->add($this->product);
            $this->isActive = true;
        }

        $this->dispatch('wishlist-updated');
    }

    public function render(): View
    {
        return view('livewire.wishlist.add-to-wishlist');
    }
}
