@props(['block', 'lazyLoading' => false])

<section class="two-content-columns component-border-radius component-white">
    <div class="container">
        <div class="row gy-3 gy-md-5">
            <div class="col-12 {{ $block->data['sizing'] === 'narrow' ? 'offset-lg-1 col-lg-5' : 'col-lg-6' }}">
                <div class="two-content-columns__column">
                    @isset($block->data['title_1'])
                        <h3 class="title">{{ $block->data['title_1'] }}</h3>
                    @endif

                    @isset($block->data['content_1'])
                        {!! $block->data['content_1'] !!}
                    @endif
                </div>
            </div>
            <div class="col-12 {{ $block->data['sizing'] === 'narrow' ? 'col-lg-5' : 'col-lg-6' }}">
                <div class="two-content-columns__column">
                    @isset($block->data['title_2'])
                        <h3 class="title">{{ $block->data['title_2'] }}</h3>
                    @endif

                    @isset($block->data['content_2'])
                        {!! $block->data['content_2'] !!}
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
