@props(['block', 'lazyLoading' => false])

@if($image = $block->media->firstWhere('pivot.properties.field', 'image'))
    <section class="image-banner component-white">
        <div class="container">
            <div class="row">
                <div class="col-12 offset-lg-1 col-lg-10">
                    <figure class="image-banner__background">
                        <img
                            src="{{ $image->getUrl() }}"
                            alt="{{ $component->data['title'] ?? '' }}"
                            loading="{{ $lazyLoading ? 'lazy': 'eager' }}"
                            fetchpriority="{{ $lazyLoading ? 'low': 'high' }}"
                        >
                    </figure>
                </div>
            </div>
        </div>
    </section>
@endif

