@props(['block', 'lazyLoading' => false])

<section class="image-cta component-margin">
    <div class="container">
        <div class="row">
            <div class="col-12 order-2 order-lg-0 offset-lg-7 col-lg-5">
                <div class="image-cta__cta">
                    @isset($block->data['title'])
                        <h2 class="title">{!! $block->data['title'] !!}</h2>
                    @endif

                    <div class="content">
                        @isset($block->data['content'])
                            {!! $block->data['content'] !!}
                        @endif
                    </div>

                    @isset($block->data['button'])
                        <a href="{{ $block->data['button']['url'] }}" class="button button--tertiary">
                            {{ $block->data['button']['label'] }}
                        </a>
                    @endisset
                </div>
            </div>
            <div class="col-12 col-lg-8">
                <figure class="image-cta__image">
                    @if($block->media->first())
                        <img src="{{ $block->media->first()->getUrl() }}" alt=""/>
                    @endif
                </figure>
            </div>

        </div>
    </div>
</section>
