@props(['block', 'lazyLoading' => false])

<section class="product-slider component-margin">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="product-slider__header">
                    <div class="content">
                        @isset($block->data['title'])
                            <h2 class="title">{!! $block->data['title'] !!}</h2>
                        @endif
                    </div>
                    @isset($block->data['button'])
                        <a href="{{ $block->data['button']['url'] }}" class="button--arrow">
                            {{ $block->data['button']['label'] }}
                            <svg role="img" aria-label="icon arrow right" xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                <g transform="translate(0.75 1.06)">
                                    <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                    <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </a>
                    @endisset
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="product-slider__slider" data-slider-products>
                    <div class="swiper-wrapper">
                        @foreach($block->products as $product)
                            <div class="swiper-slide">
                                <livewire:products.card
                                    :product="$product"
                                    :key="$product->id"
                                    :loop="$loop"
                                />
                            </div>
                        @endforeach
                    </div>

                    <div class="slider-functions">
                        <div class="swiper-buttons">
                            <button type="button" class="swiper-button prev swiper-button-products-prev" aria-label="previous slide">
                                <svg role="img" aria-label="previous slide" xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 35 35">
                                    <g id="Group_20330" data-name="Group 20330" transform="translate(-840 -585)">
                                        <g id="Rectangle_2003" data-name="Rectangle 2003" transform="translate(840 585)" fill="none" stroke="#032e61" stroke-width="1">
                                            <rect width="35" height="35" rx="17.5" stroke="none"/>
                                            <rect x="0.5" y="0.5" width="34" height="34" rx="17" fill="none"/>
                                        </g>
                                        <g id="Group_20129" data-name="Group 20129" transform="translate(19.103 -127.086)">
                                            <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.2" transform="translate(15202.998 5737.087)" fill="none" stroke="#032e61" stroke-linecap="round" stroke-width="1.5"/>
                                            <path id="Path_47988" data-name="Path 47988" d="M-14359.934-5015.933l3.808,3.809-3.808,3.808" transform="translate(15199.124 5741.711)" fill="none" stroke="#032e61" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                            </button>
                            <button type="button" class="swiper-button next swiper-button-products-next" aria-label="next slide">
                                <svg role="img" aria-label="next slide" xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 35 35">
                                    <g id="Group_20330" data-name="Group 20330" transform="translate(-840 -585)">
                                        <g id="Rectangle_2003" data-name="Rectangle 2003" transform="translate(840 585)" fill="none" stroke="#032e61" stroke-width="1">
                                            <rect width="35" height="35" rx="17.5" stroke="none"/>
                                            <rect x="0.5" y="0.5" width="34" height="34" rx="17" fill="none"/>
                                        </g>
                                        <g id="Group_20129" data-name="Group 20129" transform="translate(19.103 -127.086)">
                                            <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.2" transform="translate(15202.998 5737.087)" fill="none" stroke="#032e61" stroke-linecap="round" stroke-width="1.5"/>
                                            <path id="Path_47988" data-name="Path 47988" d="M-14359.934-5015.933l3.808,3.809-3.808,3.808" transform="translate(15199.124 5741.711)" fill="none" stroke="#032e61" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                            </button>
                        </div>
                        <div class="swiper-pagination swiper-pagination-products"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
