<div>
    <div class="product-single__gallery" data-product-image-slider>
        <div class="product-single__gallery__arrow product-single__gallery__arrow--prev">
            <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5 3 12m0 0 7.5-7.5M3 12h18"></path>
            </svg>
        </div>

        <div class="product-single__gallery__arrow product-single__gallery__arrow--next">
            <svg data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" d="M13.5 4.5 21 12m0 0-7.5 7.5M21 12H3"></path>
            </svg>
        </div>

        <div class="swiper-wrapper">
            @foreach($images as $image)
                <div class="swiper-slide" wire:key="main-{{ $image->id }}">
                    <a href="{{ $image->getUrl('gallery-2x') }}" data-fancybox="gallery-1">
                        <figure>
                            <picture>
                                <source type="image/webp" srcset="{{ $image->getUrl('gallery-webp') }}">

                                <source type="image/jpg" srcset="
                                    {{ $image->getUrl('gallery-2x') }} 2x,
                                    {{ $image->getUrl('gallery') }}
                                ">

                                <img
                                    loading="{{ $loop->index >= 4 ? 'lazy' : 'eager' }}"
                                    fetchpriority="{{ $loop->index >= 4 ? 'low' : 'high' }}"
                                    src="{{ $image->getUrl('gallery') }}"
                                    srcset="
                                        {{ $image->getUrl('gallery-2x') }} 2x,
                                        {{ $image->getUrl('gallery') }}
                                    "
                                >
                            </picture>
                        </figure>
                    </a>
                </div>
            @endforeach

            @if($videoUrl && $images->first())
                <div class="swiper-slide">
                    <a href="{{ $videoUrl }}" data-fancybox="gallery-1" class="product-single__gallery__video">
                        <figure>
                            <img src="{{ $images->first()->getUrl() }}">
                        </figure>
                    </a>
                </div>
            @endif
        </div>
    </div>

    <div class="product-single__thumbnails" data-product-gallery-slider>
        <div class="swiper-wrapper">
            @foreach($images as $image)
                <div class="swiper-slide" wire:key="gallery-{{ $image->id }}">
                    <img src="{{ $image->getUrl('square-small') }}" alt="" style="width: 64px !important;">
                </div>
            @endforeach

            @if($videoUrl && $images->first())
                <div class="swiper-slide product-single__thumbnails__video">
                    <img src="{{ $images->first()->getUrl('square-small') }}" alt="" style="width: 64px !important;">
                </div>
            @endif
        </div>
    </div>
</div>
