@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('News')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[
        $archive->name => translatedRoute('page', $archive->slug),
        $article->name => translatedRoute('news.show', $article->slug),
    ]"/>

    <article class="single-news">
        <header class="single-news__header">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <a href="{{ translatedRoute('page', $archive->slug) }}" class="button--arrow-back">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                <g id="Group_20105" data-name="Group 20105" transform="translate(843.636 1.061)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14360.113-5007.5h-9.09" transform="translate(13526.317 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988" d="M-14356.174-5015.933l-3.762,3.762,3.762,3.761" transform="translate(13517.05 5015.933)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>

                            {{ __('Back to overview') }}
                        </a>
                    </div>
                    <div class="col-12 offset-lg-3 col-lg-6">
                        <div class="wrapper">
                            <div class="pill-category">{{ __('News') }}</div>
                            <time>{{ $article->created_at->isoFormat('LL') }}</time>
                        </div>
                        <h1 class="title">{{ $article->name }}</h1>

{{--                        <x-partials.share-buttons/>--}}
                    </div>
                </div>
            </div>
        </header>

        @if($article->post->image->first())
            <div class="single-news__thumbnail component-border-radius">
                <div class="container">
                    <div class="row">
                        <div class="col-12 offset-lg-2 col-lg-8">
                            <figure class="thumbnail">
                                <img src="{{ $article->post->image->first()->getUrl()  }}" alt=""/>
                            </figure>
                        </div>
                    </div>
                </div>
            </div>
        @endif


        <div class="container">
            <div class="row">
                <div class="col-12 offset-lg-3 col-lg-6">
                    <section class="single-news__article">
                        {!! $article->content !!}
                    </section>
                </div>
            </div>
        </div>
    </article>

    {{--    <x-blocks.cta/>--}}
</x-layouts.app>
