<?php

namespace App\Daylight\Http\Controllers\Settings;

use App\Daylight\Http\Requests\Settings\UpdateUspsRequest;
use App\Daylight\Settings\USPs;
use Daylight\Core\Http\Controllers\Controller;
use Illuminate\Routing\Controllers\Middleware;

class UspsController extends Controller
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:update:settings', only: ['update']),
            new Middleware('can:read:settings', only: ['index']),
        ];
    }

    public function index(USPs $settings)
    {
        return view('daylight.settings.usps', [
            'settings' => $settings,
        ]);
    }

    public function update(UpdateUspsRequest $request, USPs $settings)
    {
        $settings->fill($request->validated())->save();

        return redirect()
            ->route('daylight.settings.usps.index')
            ->with('success', __('Settings updated'));
    }
}
