<?php

namespace App\Daylight\Http\Requests\Content\Post;

use Illuminate\Foundation\Http\FormRequest;

class StorePostRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->user()->can('update:pages');
    }

    public function rules(): array
    {
        return [
            'locale' => ['required', 'string', 'max:10'],
            'image' => ['nullable'],
            'image.*.id' => ['exists:media,id'],
            'name' => ['required', 'string', 'max:255'],
            'slug' => ['required', 'string', 'max:255'],
            'meta_title' => ['nullable', 'string', 'max:255'],
            'meta_description' => ['nullable', 'string', 'max:255'],
            'robots' => ['nullable', 'string', 'max:255'],
            'content' => ['required', 'string'],
        ];
    }

    public function prepareForValidation(): void
    {
        $this->merge([
            'image' => json_decode($this->input('image'), true),
        ]);
    }
}
