<?php

namespace App\Http\Controllers\Auth;

use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\Auth\Events\Verified;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;

class VerificationController
{
    public function unverified(Request $request)
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('verification.notice')
            ->staticRoute();

        return $request->user()->hasVerifiedEmail()
            ? redirect()->intended(translatedRoute('account.index', absolute: false))
            : view('auth.verify-email', [
                'localizedRoute' => $localizedRoute,
            ]);
    }

    public function verify(EmailVerificationRequest $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->intended(translatedRoute('account.index', absolute: false));
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
        }

        return redirect()->intended(translatedRoute('account.index', absolute: false).'?verified=1');
    }

    public function resendVerification(Request $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->intended(translatedRoute('account.index', absolute: false));
        }

        $request->user()->sendEmailVerificationNotification();

        return back()->with('status', 'verification-link-sent');
    }
}
