<?php

namespace App\Http\Controllers;

use Daylight\Core\Modules\Cart\Cart;
use Daylight\Core\Modules\Multilingualism\Entities\LocalizedRoute;
use Illuminate\View\View;

class CartController extends Controller
{
    public function __invoke(Cart $cart): View
    {
        $localizedRoute = LocalizedRoute::create()
            ->setRoute('cart.index')
            ->staticRoute();

        return view('cart.index', [
            'cart' => $cart,
            'localizedRoute' => $localizedRoute,
        ]);
    }
}
