<?php

namespace App\Modules\Wishlist\Models;

use App\Models\User;
use Daylight\Core\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Str;

class Wishlist extends Model
{
    protected $guarded = [];

    public static function booted(): void
    {
        static::creating(function (self $cart) {
            $cart->uuid = (string) Str::uuid();
        });
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class)
            ->withTimestamps()
            ->latest();
    }
}
