import Swiper from 'swiper/bundle';
import 'swiper/css/pagination';

export const productSlider = () => {
    if (document.querySelector('[data-slider-products]')) {
        const swiper = new Swiper('[data-slider-products]', {
            slidesPerView: 1.1,
            spaceBetween: 20,
            navigation: {
                nextEl: ".swiper-button-products-next",
                prevEl: ".swiper-button-products-prev",
            },
            pagination: {
                el: ".swiper-pagination-products",
                type: "progressbar",
            },
            breakpoints: {
                768: {
                    slidesPerView: 2.2,
                },
                992: {
                    slidesPerView: 2.8,
                },
                1300: {
                    spaceBetween: 30,
                    slidesPerView: 4,
                },
            },
        })
    }

    if (document.querySelector('[data-slider-testimonials]')) {
        const swiper = new Swiper('[data-slider-testimonials]', {
            slidesPerView: 1.1,
            spaceBetween: 20,
            navigation: {
                nextEl: ".swiper-button-testimonials-next",
                prevEl: ".swiper-button-testimonials-prev",
            },
            pagination: {
                el: ".swiper-pagination-testimonials",
                type: "progressbar",
            },
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1300: {
                    spaceBetween: 30,
                    slidesPerView: 3,
                },
            },
        })
    }

    if (document.querySelector('[data-slider-usps]')) {
        const swiper = new Swiper('[data-slider-usps]', {
            slidesPerView: 'auto',
            spaceBetween: 30,
            navigation: {
                nextEl: ".swiper-button-usps-next",
                prevEl: ".swiper-button-usps-prev",
            },
        })
    }
}

export const productGallerySlider = () => {
    if (!document.querySelector('[data-product-gallery-slider]')) {
        return;
    }

    window.createSliders = () => {
        let thumbnailSliderOptions = {
            loop: false,
            spaceBetween: 10,
            slidesPerView: 'auto',
            freeMode: false,
            watchSlidesProgress: true,
        };

        let gallerySliderOptions = {
            slidesPerView: 1,
            loop: true,
            navigation: {
                nextEl: ".product-single__gallery__arrow--next",
                prevEl: ".product-single__gallery__arrow--prev",
            },
        };

        const thumbnailSlider = new Swiper("[data-product-gallery-slider]", thumbnailSliderOptions)

        const gallerySlider = new Swiper('[data-product-image-slider]', {
            ...gallerySliderOptions,
            ...{
                thumbs: {
                    swiper: thumbnailSlider,
                }
            }
        })
    };

    window.createSliders()

    document.addEventListener('livewire:initialized', () => {
        Livewire.hook('morph.updated', ({component, el}) => {
            if (component.name !== 'products.product-gallery') {
                return;
            }

            if (el.classList.contains('product-single__gallery')) {
                setTimeout(() => {
                    window.createSliders()
                }, 1)
            }
        })
    })
};
