@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Account')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Account') => translatedRoute('account.index') ]"/>

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-panel :title="__('My account')">
                        <x-slot:description>
                            <p>{{ __('Fill in the form below to change your account details.') }}</p>
                        </x-slot:description>

                        <x-session-messages />

                        <form action="{{ translatedRoute('account.index') }}" method="post">
                            @csrf

                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="name"
                                        :label="__('First name')"
                                        :error="$errors->first('name')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            id="name"
                                            name="name"
                                            :value="old('name', $user->name)"
                                        />
                                    </x-input.group>
                                </div>

                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="last_name"
                                        :label="__('Last name')"
                                        :error="$errors->first('last_name')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            id="last_name"
                                            name="last_name"
                                            :value="old('last_name', $user->last_name)"
                                        />
                                    </x-input.group>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="email"
                                        :label="__('Email')"
                                        :error="$errors->first('email')"
                                        :required="true"
                                    >
                                        <x-slot:helpText>
                                            {{ __('Re-verify required.') }}
                                        </x-slot:helpText>
                                        <x-input.text
                                            id="email"
                                            name="email"
                                            type="email"
                                            :value="old('email', $user->email)"
                                        />
                                    </x-input.group>
                                </div>

                                <div class="col-12 col-md-6">
                                    <x-input.group
                                        for="phone"
                                        :label="__('Phone')"
                                        :error="$errors->first('phone')"
                                        :required="true"
                                    >
                                        <x-input.text
                                            id="phone"
                                            name="phone"
                                            type="tel"
                                            :value="old('phone', $user->phone)"
                                        />
                                    </x-input.group>
                                </div>
                            </div>

                            <div class="text-right mt-4">
                                <button class="button button--primary" type="submit">
                                    {{ __('Save') }}
                                </button>
                            </div>
                        </form>
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
