@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Login')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Login') => translatedRoute('login') ]" />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Login')">
                        <x-slot:description>
                            <p>{{ __('Please log in using your email to view our products. Fields marked with a * are required.') }}</p>
                        </x-slot:description>

                        <x-session-messages />

                        <form method="POST" action="{{ translatedRoute('login') }}">
                            @csrf
                            @honeypot

                            <x-input.group
                                for="email"
                                :label="__('Email')"
                                :error="$errors->first('email')"
                                :required="true"
                            >
                                <x-input.text
                                    id="email"
                                    type="email"
                                    name="email"
                                    :placeholder="__('name@example.com')"
                                    :value="old('email')"
                                    autofocus
                                    autocomplete="username"
                                />
                            </x-input.group>

                            <x-input.group
                                for="password"
                                :label="__('Password')"
                                :error="$errors->first('password')"
                                :required="true"
                            >
                                <x-input.text
                                    id="password"
                                    name="password"
                                    type="password"
                                    :placeholder="__('*********')"
                                    autocomplete="current-password"
                                />
                            </x-input.group>

                            <p><a href="{{ translatedRoute('password.forgot') }}">{{ __('Forgot your password?') }}</a></p>

                            <div class="row align-items-center">
                                <div class="col-6">
                                    <label class="checkbox-group" for="remember_me">
                                        <input type="checkbox" name="remember" id="remember_me">
                                        <span>{{ __('Remember me') }}</span>
                                    </label>
                                </div>

                                <div class="col-6 text-right">
                                    <button class="button button--secondary" type="submit">
                                        {{ __('Login') }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </x-panel>
                </div>

                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Register')">
                        <x-slot:description>
                            <p>{!! __('Create an account to add products and<br>view your cart.') !!}</p>

                            <a href="{{ translatedRoute('register') }}" class="button button--primary">
                                {{ __('Register') }}
                            </a>
                        </x-slot:description>

                        <x-contact-cta />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
