@props(['block', 'lazyLoading' => false])

<section class="hero">
    <div class="container">
        <div class="row">
            <div class="col-12 col-xl-9 order-xl-2">
                <div class="hero__banner">
                    <div class="background">
                        @if($block->media->first())
                            <img src="{{ $block->media->first()->getUrl() }}" alt=""/>
                        @endif
                    </div>

                    @isset($block->data['title'])
                        <h1 class="title">{!! $block->data['title'] !!}</h1>
                    @endif

                    <nav class="buttons">
                        @isset($block->data['button'])
                            <a href="{{ $block->data['button']['url'] }}" class="button button--primary">{{ $block->data['button']['label'] }}</a>
                        @endisset

                        @isset($block->data['secondary_button'])
                            <a href="{{ $block->data['secondary_button']['url'] }}" class="button button--tertiary">{{ $block->data['secondary_button']['label'] }}</a>
                        @endisset
                    </nav>
                </div>
            </div>
            <div class="col-12 col-xl-3">
                @isset($block->data['assortment'])
                    <nav class="hero__navigation">
                        <h2 class="title">{{ __('Assortment') }}</h2>
                        <ul>
                            @foreach($block->data['assortment'] as $item)
                                <li>
                                    <a href="{{ $item['url'] }}">
                                        <img class="icon-category" src="{{ Vite::asset('resources/images/placeholders/icon.svg') }}" alt="product icon"/>
                                        {{ $item['label'] }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </nav>
                @endif
            </div>

            @isset(app(\App\Daylight\Settings\USPs::class)->usps[app()->getLocale()])
                <div class="col-12 offset-xl-3 col-xl-9 order-2">
                    <div class="hero__slider" data-slider-usps>
                        <div class="swiper-wrapper">
                            @foreach(app(\App\Daylight\Settings\USPs::class)->usps[app()->getLocale()] as $usp)
                                <div class="swiper-slide">
                                    <div class="slider-item">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="13.764" height="10.036" viewBox="0 0 13.764 10.036">
                                            <path id="Path_47989" data-name="Path 47989" d="M3526.652-6174.925l3.855,3.854,7.789-8.226" transform="translate(-3525.592 6180.356)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </svg>
                                        {{ $usp }}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>
