@props([
    'label',
    'for',
    'error' => null,
    'required' => false
])


<div {{ $attributes->merge(['class' => 'input-group']) }}>
    <div class="input-group__upper {{ $error ? 'has-error' : '' }}">
        <label for="{{ $for }}" class="input-group__label">{{ $label }} {{ $required ? '*' : '' }}</label>

        @if (isset($helpText) && $helpText->hasActualContent())
            <p class="input-group__help">
                {!! $helpText !!}
            </p>
        @endif
    </div>

    <div class="input-group__input">
        {{ $slot }}

        @if ($error)
            <div class="input-group__error">{{ $error }}</div>
        @endif
    </div>
</div>
