@props(['address'])

<a class="address" href="{{ translatedRoute('account.addresses.edit', $address) }}">
    @if($address->default)
        <div class="address__label">
            <x-heroicon-s-star/>
            {{ __('Default') }}
        </div>
    @endif

    <h3>{{ $address->name }}</h3>
    <p>{{ $address->address_line_1 }}</p>
    @if($address->address_line_2)
        <p>{{ $address->address_line_1 }}</p>
    @endif
    <p>{{ $address->postal_code }} {{ $address->city }}</p>
    <p>{{ $address->country->name }}</p>
</a>
