<div class="footer">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-3">
                <div class="footer__info">
                    <a href="#" class="footer__logo">
                        <img src="{{ Vite::asset('resources/images/logo-white.svg') }}" alt="">
                    </a>

                    <div class="footer__methods">
                        @if(app(\Daylight\Core\Settings\General::class)->phoneNumber)
                            <div class="footer__contact">
                                <img src="{{ Vite::asset('resources/images/icons/icon-phone.svg') }}" alt="">

                                <div>
                                    <small>{{ __('Call us on') }}</small>
                                    <p><a href="tel:{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}">{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}</a></p>
                                </div>
                            </div>
                        @endif

                        @if(app(\Daylight\Core\Settings\General::class)->email)
                            <div class="footer__contact">
                                <img src="{{ Vite::asset('resources/images/icons/icon-email.svg') }}" alt="">

                                <div>
                                    <small>{{ __('E-mail us on') }}</small>
                                    <p>
                                        <a href="mailto:{{ app(\Daylight\Core\Settings\General::class)->email }}">
                                            {{ app(\Daylight\Core\Settings\General::class)->email }}
                                        </a>
                                    </p>
                                </div>
                            </div>
                        @endif
                    </div>

                    <div class="footer__socials">
                        <p>{{ __('Follow us on') }}</p>
                        <ul>
                            @if(app(\Daylight\Core\Settings\General::class)->facebookUrl)
                                <li>
                                    <a href="{{ app(\Daylight\Core\Settings\General::class)->facebookUrl }}" target="_blank" rel="nofollow">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-facebook.svg') }}" alt="{{ __('Facebook') }}">
                                    </a>
                                </li>
                            @endif
                            @if(app(\Daylight\Core\Settings\General::class)->linkedinUrl)
                                <li>
                                    <a href="{{ app(\Daylight\Core\Settings\General::class)->linkedinUrl }}" target="_blank" rel="nofollow">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-linkedin.svg') }}" alt="{{ __('LinkedIn') }}">
                                    </a>
                                </li>
                            @endif
                            @if(app(\Daylight\Core\Settings\General::class)->youtubeUrl)
                                <li>
                                    <a href="{{ app(\Daylight\Core\Settings\General::class)->youtubeUrl }}" target="_blank" rel="nofollow">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-youtube.svg') }}" alt="{{ __('YouTube') }}">
                                    </a>
                                </li>
                            @endif
                            @if(app(\Daylight\Core\Settings\General::class)->instagramUrl)
                                <li>
                                    <a href="{{ app(\Daylight\Core\Settings\General::class)->instagramUrl }}" target="_blank" rel="nofollow">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-instagram.svg') }}" alt="{{ __('Instagram') }}">
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-3">
                <div class="footer__navigation">
                    <h3>{{ __('Assortment') }}</h3>

                    @if($firstFooterNavigation)
                        <ul>
                            @foreach($firstFooterNavigation as $item)
                                <li>
                                    <a href="{{ $item->url }}">
                                        {{ $item->name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-3">
                <div class="footer__navigation">
                    <h3>{{ __('Quick navigation') }}</h3>

                    @if($secondFooterNavigation)
                        <ul>
                            @foreach($secondFooterNavigation as $item)
                                <li>
                                    <a href="{{ $item->url }}">
                                        {{ $item->name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </div>
            </div>

            <div class="col-12 col-md-12 col-lg-3">
                <div class="footer__payment">
                    <h3>{{ __('Payment methods') }}</h3>

                    <ul>
                        <li><img src="{{ Vite::asset('resources/images/icons/icon-apple-pay.svg') }}" alt=""></li>
                        <li><img src="{{ Vite::asset('resources/images/icons/icon-bancontact.svg') }}" alt=""></li>
                        <li><img src="{{ Vite::asset('resources/images/icons/icon-ideal.svg') }}" alt=""></li>
                        <li><img src="{{ Vite::asset('resources/images/icons/icon-klarna.svg') }}" alt=""></li>
                        <li><img src="{{ Vite::asset('resources/images/icons/icon-paypal.svg') }}" alt=""></li>
                    </ul>
                </div>

                <div class="footer__rating">
                    <h3>{{ __('Customers give us a') }}</h3>

                    <div class="footer__reviews">
                        <div class="footer__stars">
                            <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                            <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                            <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                            <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                            <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                        </div>

                        {!! __('<strong>:score</strong> out of <a href=":url">:total reviews</a>', ['score' => 9.5, 'total' => 345, 'url' => '#']) !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="footer__copyright">
            <div>
                <p>&copy; {{ date('Y') }} {{ app(\Daylight\Core\Settings\General::class)->name ?: config('app.name') }}. {{ __('All rights reserved') }}</p>
            </div>

            <div>
                <ul>
                    @if($legalNavigation)
                        @foreach($legalNavigation as $item)
                            <li>
                                <a href="{{ $item->url }}">
                                    {{ $item->name }}
                                </a>
                            </li>
                        @endforeach
                    @endif

                    <li>
                        <a href="https://every-day.nl/" target="_blank">
                            {{ __('Realisation by Every Day') }}
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
