@props(['paginatedArticles'])
<section class="news-archive component-border-radius component-white">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="news-archive__filters">
                    <x-partials.filter-sort-by
                        :label="__('Sort by')"
                        :options="[
                            'newest' => __('Newest'),
                            'oldest' => __('Oldest'),
                        ]"
                    />
                </div>
            </div>

            <div class="col-12">
                <hr class="news-archive__divider">
            </div>
        </div>

        <div class="row gy-5">
            @foreach($paginatedArticles as $article)
                <div class="col-12 col-md-6 col-lg-4">
                    <x-cards.news :article="$article" />
                </div>
            @endforeach

            <div class="col-12 mb-8">
                <div class="news-archive__pagination">
                    {{ $paginatedArticles->links() }}
                </div>
            </div>
        </div>
    </div>
</section>
