@if ($paginator->hasPages())
    <div class="filter-pagination">
        <nav class="filter-pagination" aria-label="Pagination">
            <ul class="pagination-list">
                @if ($paginator->onFirstPage())
                    <li>
                        <button class="filter previous not-active" aria-label="Previous page">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                 viewBox="0 0 10.59 9.645">
                                <g id="Group_20105" data-name="Group 20105" transform="translate(0.75 1.061)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.09"
                                          transform="translate(14369.203 5011.262)" fill="none" stroke="currentColor"
                                          stroke-linecap="round" stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.936-5015.933l3.762,3.763-3.762,3.761"
                                          transform="translate(14365.264 5015.933)" fill="none" stroke="currentColor"
                                          stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </button>
                    </li>
                @else
                    <li>
                        <a class="filter previous" aria-label="Previous page"
                           href="{{ $paginator->previousPageUrl() }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                 viewBox="0 0 10.59 9.645">
                                <g id="Group_20105" data-name="Group 20105" transform="translate(0.75 1.061)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.09"
                                          transform="translate(14369.203 5011.262)" fill="none" stroke="currentColor"
                                          stroke-linecap="round" stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.936-5015.933l3.762,3.763-3.762,3.761"
                                          transform="translate(14365.264 5015.933)" fill="none" stroke="currentColor"
                                          stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </a>
                    </li>
                @endif

                @foreach ($elements as $element)
                    {{-- "Three Dots" Separator --}}
                    @if (is_string($element))
                        <li>
                            <button class="filter">...</button>
                        </li>
                    @endif

                    {{-- Array Of Links --}}
                    @if (is_array($element))
                        @foreach ($element as $page => $url)
                            @if ($page == $paginator->currentPage())
                                <li>
                                    <button class="filter active" aria-current="page">
                                        {{ $page }}
                                    </button>
                                </li>
                            @else
                                <li>
                                    <a class="filter" href="{{ $url }}">
                                        {{ $page }}
                                    </a>
                                </li>
                            @endif
                        @endforeach
                    @endif
                @endforeach

                {{-- Next Page Link --}}
                @if ($paginator->hasMorePages())
                    <li>
                        <a class="filter next" aria-label="Next page" href="{{ $paginator->nextPageUrl() }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                 viewBox="0 0 10.59 9.645">
                                <g id="Group_20105" data-name="Group 20105" transform="translate(0.75 1.061)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.09"
                                          transform="translate(14369.203 5011.262)" fill="none" stroke="currentColor"
                                          stroke-linecap="round"
                                          stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.936-5015.933l3.762,3.763-3.762,3.761"
                                          transform="translate(14365.264 5015.933)" fill="none" stroke="currentColor"
                                          stroke-linecap="round"
                                          stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </a>
                    </li>
                @else
                    <li>
                        <button class="filter next not-active" aria-label="Next page">
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645"
                                 viewBox="0 0 10.59 9.645">
                                <g id="Group_20105" data-name="Group 20105" transform="translate(0.75 1.061)">
                                    <path id="Path_47987" data-name="Path 47987" d="M-14369.2-5007.5h9.09"
                                          transform="translate(14369.203 5011.262)" fill="none" stroke="currentColor"
                                          stroke-linecap="round"
                                          stroke-width="1.5"/>
                                    <path id="Path_47988" data-name="Path 47988"
                                          d="M-14359.936-5015.933l3.762,3.763-3.762,3.761"
                                          transform="translate(14365.264 5015.933)" fill="none" stroke="currentColor"
                                          stroke-linecap="round"
                                          stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </button>
                    </li>
                @endif
            </ul>
        </nav>
    </div>

@endif
