@props(['localizedRoute' => null])
<div class="c-usps">
    <div class="container">
        <div class="c-usps__inner">
            <div class="c-usps__reviews">
                <div class="c-usps__stars">
                    <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                    <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                    <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                    <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                    <img src="{{ Vite::asset('resources/images/icons/icon-star.svg') }}" alt="{{ __('Star') }}">
                </div>

                {!! __('<strong>:score</strong> out of <a href=":url">:total reviews</a>', ['score' => 9.5, 'total' => 345, 'url' => '#']) !!}
            </div>

            <ul class="c-usps__navigation">
                @if($secondaryNavigation)
                    @foreach($secondaryNavigation as $item)
                        <li>
                            <a href="{{ $item->url }}">
                                {{ $item->name }}
                            </a>
                        </li>
                    @endforeach
                @endif

                @if($localizedRoute && config('multilingualism.show_locale_selector') && \Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->count() > 1)
                    <li>
                        <a href="{{ $localizedRoute->getHrefLangLinks()[app()->getLocale()] }}">
                            <img src="{{ Vite::asset('resources/images/flags/'.app()->getLocale().'.svg') }}" alt="{{ app()->getLocale() }}" class="flag">
                        </a>

                        <ul>
                            @foreach($localizedRoute->getHrefLangLinks(false) as $locale => $url)
                                <li>
                                    <a href="{{ $url }}">
                                        <img src="{{ daylightAsset('resources/assets/images/flags/'.strtolower($locale).'.svg') }}" alt="{{ $locale }}" class="flag">
                                        {{ strtoupper($locale) }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</div>
