@props([
    'name',
    'title' => '',
    'entangle' => null,
    'position' => 'right',
])

<div
    @if($entangle)
        x-data="{
            isVisible: $wire.entangle('{{ $entangle }}')
        }"
    @else
        x-data="{
            isVisible: false
        }"
    @endif
    x-on:close.stop="isVisible = false"
    x-on:toggle-slide-over.window="$event.detail == '{{ $name }}' ? isVisible = !isVisible : null"
    x-on:keydown.escape.window="isVisible = false"
    x-show="isVisible"
    x-cloak
    class="slide-over slide-over--{{ $position }} slide-over-{{ $name }}"
    {{ $attributes }}
>
    <div
        class="slide-over__backdrop"
        x-show="isVisible"
        x-transition.opacity.delay.50ms
        x-transition.opacity.duration.300ms
    ></div>

    <div
        x-on:click.outside="isVisible = false"
        x-transition:enter-start="tf-{{ $position }}-100"
        x-transition:enter-end="tf-0"
        x-transition:leave-start="tf-0"
        x-transition:leave-end="tf-{{ $position }}-100"
        x-show="isVisible"
        class="slide-over__inner"
    >
        @if(isset($header) && $header->hasActualContent())
            {{ $header }}
        @else
            <div class="slide-over__header">
                <div class="container">
                <div class="slide-over__header-inner">
                    <div class="slide-over__left">
                        @if($title)
                            <h3>{{ $title }}</h3>
                        @endif
                    </div>

                    <div class="slide-over__right">
                        @if(isset($navigation) && $navigation->hasActualContent())
                            {{ $navigation }}
                        @else
                            <ul class="slide-over__icons">
                                <li class="slide-over__offcanvas">
                                    <button @click.prevent="isVisible = !isVisible">
                                        <img src="{{ Vite::asset('resources/images/icons/icon-close.svg') }}" alt="{{ __('Close') }}">
                                    </button>
                                </li>
                            </ul>
                        @endif
                    </div>
                </div>
            </div>
            </div>
        @endif

        <div class="slide-over__content">
            {{ $slot }}
        </div>

        @if (isset($footer) && $footer->hasActualContent())
            <div class="slide-over__footer">
                {{ $footer }}
            </div>
        @endif
    </div>
</div>
