@extends('daylight::layouts.app')

@section('title', __('Create new question category'))

@section('content')
    <x-daylight::page-header :title="__('Create new question category')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.content.question-categories.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('Locale')"
            :error="$errors->first('locale')"
            for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}"/>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.question-categories.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
