@extends('daylight::layouts.app')

@section('title', __('Create new question'))

@section('content')
    <x-daylight::page-header :title="__('Create new question')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.content.questions.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('Locale')"
            :error="$errors->first('locale')"
            for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Category')"
            :error="$errors->first('question_category_id')"
            for="question_category_id"
        >
            <x-daylight::input.select name="question_category_id" id="question_category_id">
                <option value="">{{ __('Select a category') }}</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ old('question_category_id') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Content')"
            :error="$errors->first('content')"
            for="content"
        >
            <x-daylight::input.textarea name="content" id="content">{{ old('content') }}</x-daylight::input.textarea>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.questions.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
