@props(['facet', 'activeRange', 'active' => true])

<div class="filter-group {{ $active ? 'active' : '' }}" data-product-filter-group="{{ $facet->property }}"
     wire:key="{{ $facet->property }}">
    <div class="filter-group__title">
        <button data-product-filter-toggle>
            {{ $facet->name }}

            <svg xmlns="http://www.w3.org/2000/svg" width="7.648" height="3.824">
                <path fill="#171716" d="M7.648 0 3.824 3.824 0 0Z" data-name="Path 6546"/>
            </svg>
        </button>
    </div>

    <div class="filter-group__filters {{ $active ? 'active' : '' }}" data-product-filter-filters x-data="rangeSlider" x-init="init()">
        <div class="range-slider">
            <input class="range-slider__input" type="range" step="1" :min="initialMinimum" :max="initialMaximum"
                   @input="onChangeMinimumTrigger();" x-model.number="selectedMinimum" @change="maybeUpdate">
            <input class="range-slider__input" type="range" step="1" :min="initialMinimum" :max="initialMaximum"
                   @input="onChangeMaximumTrigger()" x-model.number="selectedMaximum" @change="maybeUpdate">

            <div class="range-slider__bar">
                <div class="range-slider__bar-background"></div>
                <div class="range-slider__bar-active"
                     :style="'right:'+calculatedOffsetRight+'%; left:'+calculatedOffsetLeft+'%'"></div>
                <div class="range-slider__handle range-slider__handle--left"
                     :style="'left: '+calculatedOffsetLeft+'%'"></div>
                <div class="range-slider__handle range-slider__handle--right"
                     :style="'right: '+calculatedOffsetRight+'%'"></div>
            </div>
        </div>

        <div class="range-slider__inputs">
            <input type="number" x-model.number="selectedMinimum"
                   :min="initialMinimum" :max="initialMaximum - 100"
                   :name="shouldActivateFilters ? 'filters[price][min]' : ''"
                   @change="onChangeMinimumTrigger(); selectFilters()">

            <input type="number" x-model.number="selectedMaximum"
                   :min="initialMinimum + 100" :max="initialMaximum"
                   :name="shouldActivateFilters ? 'filters[price][max]' : ''"
                   @change="onChangeMaximumTrigger(); selectFilters()">
        </div>

        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.data('rangeSlider', () => ({
                    initialMinimum: {{ $facet->range['min'] }},
                    initialMaximum: {{ $facet->range['max'] }},
                    selectedMinimum: {{ $activeRange->originalValues['min'] ?? $facet->range['min'] }},
                    selectedMaximum: {{ $activeRange->originalValues['max'] ?? $facet->range['max'] }},
                    calculatedOffsetLeft: 0,
                    calculatedOffsetRight: 0,

                    init() {
                        this.onChangeMinimumTrigger();
                        this.onChangeMaximumTrigger();

                        // On livewire update
                        Livewire.hook('message.processed', (message, component) => {
                            this.selectedMinimum = {{ $facet->range['min'] }};
                            this.selectedMaximum = {{ $facet->range['max'] }};

                            this.onChangeMinimumTrigger();
                            this.onChangeMaximumTrigger();
                        });
                    },

                    maybeUpdate() {
                        this.selectFilters(false);
                    },

                    onChangeMinimumTrigger() {
                        this.selectedMinimum = Math.min(this.selectedMinimum, this.selectedMaximum);
                        this.calculatedOffsetLeft = ((this.selectedMinimum - this.initialMinimum) / (this.initialMaximum - this.initialMinimum)) * 100;
                    },

                    onChangeMaximumTrigger() {
                        this.selectedMaximum = Math.max(this.selectedMaximum, this.selectedMinimum);
                        this.calculatedOffsetRight = 100 - (((this.selectedMaximum - this.initialMinimum) / (this.initialMaximum - this.initialMinimum)) * 100);
                    },

                    formatCurrency(value) {
                        return new Intl.NumberFormat(this.locale, {
                            style: 'currency',
                            currency: 'EUR',
                            maximumFractionDigits: 0
                        }).format(value);
                    },

                    selectFilters(withDebounce = true) {
                        if(!withDebounce) {
                            if (this.shouldActivateFilters) {
                                this.$wire.set('filters.price.min', this.selectedMinimum);
                                this.$wire.set('filters.price.max', this.selectedMaximum);
                            }
                            return;
                        }

                        this.debounce(() => {
                            if (this.shouldActivateFilters) {
                                this.$wire.set('filters.price.min', this.selectedMinimum);
                                this.$wire.set('filters.price.max', this.selectedMaximum);
                            }
                        })();
                    },

                    shouldActivateFilters() {
                        return this.selectedMinimum !== this.initialMinimum || this.selectedMaximum !== this.initialMaximum;
                    },

                    debounce(func, wait = 250) {
                        let timeout;
                        return function (...args) {
                            clearTimeout(timeout);
                            timeout = setTimeout(() => func.apply(this, args), wait);
                        };
                    }
                }));
            });
        </script>
    </div>
</div>


