<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class CTABlocks extends Component
{
    public string $type = 'cta-blocks';

    public function name(): string
    {
        return __('CTA Blocks');
    }

    public function fields(): Collection
    {
        return collect([
            Field::media('contact_image', __('Contact image')),
            Field::text('contact_name', __('Contact name'))->required(),
            Field::text('contact_function', __('Contact function'))->required(),

            Field::text('maintenance_title', __('Maintenance title'))->required(),
            Field::wysiwyg('maintenance_content', __('Maintenance content'))->required(),
            Field::text('maintenance_button', __('Maintenance button'))->required(),
            Field::text('maintenance_url', __('Maintenance URL'))->required(),

            Field::text('cta_title', __('CTA title'))->required(),
            Field::repeater('cta_usps', __('CTA content'), [
                Field::text('usp', __('USP'))->required(),
            ])->required(),

            Field::text('stock_title', __('Stock title'))->required(),
            Field::wysiwyg('stock_content', __('Stock content'))->required(),
        ]);
    }
}
