<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class ContentColumns extends Component
{
    public string $type = 'content-columns';

    public function name(): string
    {
        return __('Content (2 Columns)');
    }

    public function fields(): Collection
    {
        return collect([
            Field::select('sizing', __('Sizing'), [
                'narrow' => __('Narrow'),
                'wide' => __('Wide'),
            ])->required(),
            Field::text('title_1', __('Title (Left)'))->required(),
            Field::wysiwyg('content_1', __('Content (Left)'))->required(),
            Field::text('title_2', __('Title (Right)'))->required(),
            Field::wysiwyg('content_2', __('Content (Right)'))->required(),
        ]);
    }
}
