<?php

namespace App\Components;

use App\Models\QuestionCategory;
use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class CustomerService extends Component
{
    public string $type = 'customer-service';

    public function name(): string
    {
        return __('Customer Service');
    }

    public function fields(): Collection
    {
        return collect([
            Field::related(
                name: 'questionCategories',
                label: __('Category'),
                type: QuestionCategory::class,
                items: QuestionCategory::get()
                    ->map(function (QuestionCategory $questionCategory) {
                        return [
                            'id' => $questionCategory->id,
                            'label' => $questionCategory->name,
                        ];
                    })->toArray(),
            )->required(),
            Field::button('faq', __('FAQ')),
        ]);
    }
}
