<?php

namespace App\Components;

use Daylight\Core\Modules\PageBuilder\Entities\Component;
use Daylight\Core\Modules\PageBuilder\Entities\Field;
use Illuminate\Support\Collection;

class PageHeader extends Component
{
    public string $type = 'page-header';

    public function name(): string
    {
        return __('Page header');
    }

    public function fields(): Collection
    {
        return collect([
            Field::text('title', __('Title'))->required(),
            Field::wysiwyg('content', __('Content')),
        ]);
    }
}
