<?php

namespace App\Livewire\Checkout\Forms;

use Livewire\Form;

class Details extends Form
{
    public array $accountDetails = [
        'email' => null,
        'type' => 'individual',
        'name' => null,
        'last_name' => null,
    ];

    public array $billingAddress = [
        'name' => null,
        'vat_number' => null,
        'vat_number_verified_at' => null,
        'address_line_1' => null,
        'address_line_2' => null,
        'postal_code' => null,
        'city' => null,
        'country_id' => 26,
    ];

    public bool $copyShippingAddressFromBilling = false;

    public array $shippingAddress = [
        'name' => null,
        'address_line_1' => null,
        'address_line_2' => null,
        'postal_code' => null,
        'city' => null,
        'country_id' => 26,
    ];

    public string $shippingMethod = 'shipping';

    public string $paymentMethod = 'ideal';

    public $notes = null;

    public bool $terms = false;

    public bool $privacy = false;

    public function rules(): array
    {
        return [
            'accountDetails.type' => 'required|in:individual,business',
            'accountDetails.email' => 'required|email|unique:users,email'.(auth()->check() ? ','.auth()->id() : ''),
            'accountDetails.name' => 'required',
            'accountDetails.last_name' => 'required',
            'accountDetails.phone' => 'required',

            'billingAddress.name' => 'required_if:accountDetails.type,business',
            'billingAddress.vat_number' => 'nullable',
            'billingAddress.vat_number_verified_at' => 'nullable',
            'billingAddress.address_line_1' => 'required',
            'billingAddress.address_line_2' => 'nullable',
            'billingAddress.postal_code' => 'required',
            'billingAddress.city' => 'required',
            'billingAddress.country_id' => 'required',

            'shippingAddress.name' => 'required_if:copyShippingAddressFromBilling,false',
            'shippingAddress.address_line_1' => 'required_if:copyShippingAddressFromBilling,false',
            'shippingAddress.address_line_2' => 'nullable',
            'shippingAddress.postal_code' => 'required_if:copyShippingAddressFromBilling,false',
            'shippingAddress.city' => 'required_if:copyShippingAddressFromBilling,false',
            'shippingAddress.country_id' => 'required',

            'shippingMethod' => 'required|in:shipping,pickup',
            'notes' => 'nullable',

            'terms' => 'accepted',
        ];
    }

    public function messages(): array
    {
        return [
            'accountDetails.email.unique' => __('It seems like you already have an account. Please sign in first.'),
        ];
    }

    public function getValidationAttributes(): array
    {
        return [
            'accountDetails.type' => __('account type'),
            'accountDetails.email' => __('email address'),
            'accountDetails.name' => __('first name'),
            'accountDetails.last_name' => __('last name'),
            'accountDetails.phone' => __('phone'),

            'billingAddress.name' => __('name'),
            'billingAddress.vat_number' => __('VAT number'),
            'billingAddress.vat_number_verified_at' => __('VAT number verified at'),
            'billingAddress.address_line_1' => __('address line 1'),
            'billingAddress.address_line_2' => __('address line 2'),
            'billingAddress.postal_code' => __('postal code'),
            'billingAddress.city' => __('city'),
            'billingAddress.country_id' => __('country'),

            'shippingAddress.name' => __('name'),
            'shippingAddress.address_line_1' => __('address line 1'),
            'shippingAddress.address_line_2' => __('address line 2'),
            'shippingAddress.postal_code' => __('postal code'),
            'shippingAddress.city' => __('city'),
            'shippingAddress.country_id' => __('country'),

            'shippingMethod' => __('shipping method'),
            'notes' => __('notes'),
        ];
    }
}
