<?php

namespace App\Livewire\Checkout;

use App\Livewire\Cart\Concerns\InteractsWithCart;
use Daylight\Core\Models\Enums\OrderStatus;
use Daylight\Core\Models\Order;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;
use Livewire\Component;

class OrderOverview extends Component
{
    use InteractsWithCart;

    public Order $order;

    public OrderStatus $status = OrderStatus::PENDING;

    public function refreshStatus(): void
    {
        $this->order->fresh();

        $this->status = $this->order->status;
    }

    //    public function retryPayment()
    //    {
    //        $payment = app(PaymentBuilder::class)
    //            ->forOrder($this->order)
    //            ->withoutPreferredPaymentMethod()
    //            ->create();
    //
    //        return $payment->redirect();
    //    }

    public function cancel(): RedirectResponse
    {
        $this->order->update([
            'status' => OrderStatus::CANCELLED,
            'payment_gateway_status' => 'cancelled',
        ]);

        //        app(PaymentBuilder::class)
        //            ->forOrder($this->order)
        //            ->cancel();

        return redirect()->translatedRoute('page');
    }

    public function mount(): void
    {
        $this->status = $this->order->status;
    }

    public function render(): View
    {
        return view('livewire.checkout.order-overview');
    }
}
