<?php

namespace App\Livewire\Products;

use Daylight\Core\Models\Product;
use Daylight\Core\Models\Variant;
use Daylight\Core\Modules\Cart\Contracts\CartInterface;
use Livewire\Component;

class Card extends Component
{
    public Product $product;

    public function addToCart(Variant $variant): void
    {
        app(CartInterface::class)->add($variant);

        $this->dispatch('add-to-cart', $variant->getDataLayerInformation());

        $this->dispatch('cart-updated');
        $this->dispatch('show-cart-summary');
    }

    public function render()
    {
        return view('livewire.products.card');
    }
}
