<?php

namespace App\Livewire\Products;

use Daylight\Core\Models\Variant;
use Daylight\Core\Modules\Pricing\Facades\Pricing;
use Livewire\Attributes\On;
use Livewire\Component;

class Price extends Component
{
    public Variant $variant;

    public int $quantity = 1;

    #[On('current-variant-changed')]
    public function currentVariantChanged(Variant $variant)
    {
        $this->variant = $variant;
    }

    #[On('quantity-changed')]
    public function quantityChanged(int $quantity)
    {
        $this->quantity = $quantity;
    }

    public function getPrice(): \Daylight\Core\Models\Price
    {
        //        $quantity = app(CartInterface::class)
        //            ->getQuantityForVariant($this->variant);

        return Pricing::for($this->variant)
            ->quantity($this->quantity)
            ->get()
            ->matched;
    }

    public function price(): int
    {
        return $this->getPrice()->price;
    }

    public function priceIncludingVat(): int
    {
        return $this->getPrice()->priceIncludingVat;
    }

    public function render()
    {
        return view('livewire.products.price');
    }
}
