<?php

namespace App\Models;

use App\Models\Translations\QuestionTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Question extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name', 'content'];
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(QuestionCategory::class);
    }

    public function translations(): HasMany
    {
        return $this->hasMany(QuestionTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(QuestionTranslation::class)
            ->where('locale', config('app.locale'));
    }
}
