<?php

namespace App\Modules\Wishlist\Http\Middleware;

use App\Modules\Wishlist\Contracts\WishlistInterface;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureWishlistSessionCreated
{
    public function __construct(
        protected WishlistInterface $wishlist
    ) {
        //
    }

    public function handle(Request $request, Closure $next): Response
    {
        if (! $this->wishlist->exists()) {
            $this->wishlist->create($request->user());
        }

        return $next($request);
    }
}
