<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\LaravelSettings\Migrations\SettingsMigrator;

class SettingsSeeder extends Seeder
{
    protected SettingsMigrator $migrator;

    public function __construct()
    {
        $this->migrator = app(SettingsMigrator::class);
    }

    public function run(): void
    {
        $this->migrator->add('usps.usps', [
            'en' => [
                'USP 1',
                'USP 2',
                'USP 3',
                'USP 4',
            ],
            'nl' => [
                'USP 1',
                'USP 2',
                'USP 3',
                'USP 4',
            ],
        ]);
    }
}
