@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Account')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Account') => translatedRoute('account.index'),
            __('Addresses') => translatedRoute('account.addresses.index'),
        ]"
    />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-session-messages />

                    <x-panel :title="__('Billing addresses')">
                        <x-slot:description>
                            <p>{{ __('Select an address below to view or change details.') }}</p>
                        </x-slot:description>

                        <x-slot:actions>
                            <a href="{{ translatedRoute('account.addresses.create', ['type' => 'billing']) }}" class="button button--secondary">
                                {{ __('Add address') }}
                            </a>
                        </x-slot:actions>

                        @foreach($billingAddresses as $billingAddress)
                            <x-partials.address :address="$billingAddress" />
                        @endforeach
                    </x-panel>

                    <x-panel :title="__('Shipping addresses')">
                        <x-slot:description>
                            <p>{{ __('Select an address below to view or change details.') }}</p>
                        </x-slot:description>

                        <x-slot:actions>
                            <a href="{{ translatedRoute('account.addresses.create', ['type' => 'shipping']) }}" class="button button--secondary">
                                {{ __('Add address') }}
                            </a>
                        </x-slot:actions>

                        @foreach($shippingAddresses as $shippingAddress)
                            <x-partials.address :address="$shippingAddress" />
                        @endforeach
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
