@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Orders')" :localizedRoute="$localizedRoute">
    <x-breadcrumbs
        :pages="[
            __('Account') => translatedRoute('account.index'),
            __('Orders') => translatedRoute('account.orders.index'),
        ]"
    />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                @include('account.navigation')

                <div class="col-12 col-lg-9">
                    <x-session-messages />

                    <x-panel :title="__('Orders')">
                        <x-slot:description>
                            <p>{{ __('Select an order below to view details.') }}</p>
                        </x-slot:description>

                        @foreach($orders as $order)
                            <x-partials.order :order="$order" />
                        @endforeach
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
