@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Forgot Password')"  :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Forgot Password') => translatedRoute('password.forgot') ]" />

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Forgot Password')">
                        <x-slot:description>
                            <p>{{ __('Please enter your email address to receive a link to reset your password. Fields marked with a * are required.') }}</p>
                        </x-slot:description>

                        <x-session-messages />

                        <form method="POST" action="{{ translatedRoute('password.forgot') }}">
                            @csrf
                            @honeypot

                            <x-input.group
                                for="email"
                                :label="__('Email')"
                                :error="$errors->first('email')"
                                :required="true"
                            >
                                <x-input.text
                                    id="email"
                                    type="email"
                                    name="email"
                                    :placeholder="__('name@example.com')"
                                    :value="old('email')"
                                    autofocus
                                    autocomplete="username"
                                />
                            </x-input.group>

                            <button class="button button--secondary mt-4" type="submit">
                                {{ __('Reset password') }}
                            </button>
                        </form>
                    </x-panel>
                </div>

                <div class="col-12 col-lg-6">
                    <x-panel :title="__('No account yet?')">
                        <x-slot:description>
                            <p>{!! __('Create an account to add products and view your cart.') !!}</p>

                            <a href="{{ translatedRoute('register') }}" class="button button--primary">
                                {{ __('Register') }}
                            </a>
                        </x-slot:description>


                        <x-contact-cta />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
