@section('head')
    <link rel="canonical" href="{{ $localizedRoute->getCanonical()  }}"/>

    @foreach($localizedRoute->getHrefLangLinks() as $locale => $link)
        <link rel="alternate" hreflang="{{ $locale }}" href="{{ $link }}">
    @endforeach
@endsection

<x-layouts.app :title="__('Register')"  :localizedRoute="$localizedRoute">
    <x-breadcrumbs :pages="[ __('Register') => translatedRoute('register') ]"/>

    <main class="bg-white padding">
        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Register')">
                        <x-slot:description>
                            <p>{{ __('To add products to your shopping cart, you need an account. All orders are processed on account or by quote. Easily create your order by adding products to your shopping cart.') }}</p>
                        </x-slot:description>

                        <x-session-messages/>

                        @if(!session('success'))
                            <form method="POST" action="{{ translatedRoute('register') }}">
                                @csrf
                                @honeypot

                                <x-input.group
                                    for="email"
                                    :label="__('Email')"
                                    :error="$errors->first('email')"
                                    :required="true"
                                >
                                    <x-input.text
                                        id="email"
                                        type="email"
                                        name="email"
                                        :placeholder="__('name@example.com')"
                                        :value="old('email')"
                                        autofocus
                                        autocomplete="username"
                                    />

                                    <x-slot:helpText>
                                        {!! __('Do you already have a account? <a href=":url">Sign in</a>', ['url' => translatedRoute('login')]) !!}
                                    </x-slot:helpText>
                                </x-input.group>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="name"
                                            :label="__('First name')"
                                            :error="$errors->first('name')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="name"
                                                name="name"
                                                type="text"
                                                :placeholder="__('John')"
                                                :value="old('name')"
                                            />
                                        </x-input.group>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="last_name"
                                            :label="__('Last name')"
                                            :error="$errors->first('last_name')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="last_name"
                                                name="last_name"
                                                type="text"
                                                :placeholder="__('Doe')"
                                                :value="old('last_name')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="company_name"
                                            :label="__('Company name')"
                                            :error="$errors->first('company_name')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="company_name"
                                                name="company_name"
                                                type="text"
                                                :placeholder="__('Acme Inc.')"
                                                :value="old('company_name')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="phone"
                                            :label="__('Phone')"
                                            :error="$errors->first('phone')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="phone"
                                                name="phone"
                                                type="tel"
                                                :placeholder="__('+31 85 123 4567')"
                                                :value="old('phone')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="kvk"
                                            :label="__('KVK number')"
                                            :error="$errors->first('kvk')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="kvk"
                                                name="kvk"
                                                type="text"
                                                :placeholder="__('12345678')"
                                                :value="old('kvk')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="vat"
                                            :label="__('VAT number')"
                                            :error="$errors->first('vat')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="vat"
                                                name="vat"
                                                type="text"
                                                :placeholder="__('NL123456789B01')"
                                                :value="old('vat')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="street"
                                            :label="__('Street')"
                                            :error="$errors->first('street')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="street"
                                                name="street"
                                                type="street"
                                                :placeholder="__('Main Street')"
                                                :value="old('street')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-3">
                                        <x-input.group
                                            for="house_number"
                                            :label="__('House number')"
                                            :error="$errors->first('house_number')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="house_number"
                                                name="house_number"
                                                type="house_number"
                                                :placeholder="__('123')"
                                                :value="old('house_number')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-3">
                                        <x-input.group
                                            for="addition"
                                            :label="__('Addition')"
                                            :error="$errors->first('addition')"
                                            :required="false"
                                        >
                                            <x-input.text
                                                id="addition"
                                                name="addition"
                                                type="addition"
                                                :placeholder="__('a')"
                                                :value="old('addition')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="postal_code"
                                            :label="__('Postal code')"
                                            :error="$errors->first('postal_code')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="postal_code"
                                                name="postal_code"
                                                type="text"
                                                :placeholder="__('1234 AB')"
                                                :value="old('postal_code')"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="city"
                                            :label="__('City')"
                                            :error="$errors->first('city')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="city"
                                                name="city"
                                                type="text"
                                                :placeholder="__('Amsterdam')"
                                                :value="old('city')"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <x-input.group
                                    for="country"
                                    :label="__('Country')"
                                    :error="$errors->first('country')"
                                    :required="true"
                                >
                                    <x-input.select
                                        id="country"
                                        name="country"
                                    >
                                        @foreach($countries as $id => $country)
                                            <option value="{{$id }}" @if($id == old('country', 26)) selected @endif>
                                                {{ $country }}
                                            </option>
                                        @endforeach
                                    </x-input.select>
                                </x-input.group>

                                <x-input.group
                                    for="notes"
                                    :label="__('Notes')"
                                    :error="$errors->first('notes')"
                                    :required="false"
                                >
                                    <x-input.textarea
                                        id="notes"
                                        name="notes"
                                        :placeholder="__('Notes..')"
                                    >{{ old('notes') }}</x-input.textarea>
                                </x-input.group>

                                <div class="row">
                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="password"
                                            :label="__('Password')"
                                            :error="$errors->first('password')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="password"
                                                name="password"
                                                type="password"
                                                :placeholder="__('*********')"
                                                autocomplete="current-password"
                                            />
                                        </x-input.group>
                                    </div>

                                    <div class="col-12 col-md-6">
                                        <x-input.group
                                            for="password_confirmation"
                                            :label="__('Password confirmation')"
                                            :error="$errors->first('password_confirmation')"
                                            :required="true"
                                        >
                                            <x-input.text
                                                id="password_confirmation"
                                                name="password_confirmation"
                                                type="password"
                                                :placeholder="__('*********')"
                                                autocomplete="current-password"
                                            />
                                        </x-input.group>
                                    </div>
                                </div>

                                <div class="row align-items-center">
                                    <div class="col-6">
                                        <label class="checkbox-group" for="terms">
                                            <input
                                                type="checkbox"
                                                name="terms"
                                                id="terms"
                                                required
                                                @if(old('terms')) checked @endif
                                            >
                                            <span>
                                            {!! __('I agree to the <a href=":url">terms and conditions</a>', ['url' => '#']) !!}
                                        </span>
                                        </label>
                                    </div>

                                    <div class="col-6 text-right">
                                        <button class="button button--primary" type="submit">
                                            {{  __('Request an account') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        @endif
                    </x-panel>
                </div>

                <div class="col-12 col-lg-6">
                    <x-panel :title="__('Already registered?')">
                        <x-slot:description>
                            <p>{{ __('Log in to your account to add products to your shopping cart and view your cart.') }}</p>

                            <a href="{{  translatedRoute('login') }}" class="button button--primary">{{ __('Login') }}</a>
                        </x-slot:description>

                        <x-contact-cta />
                    </x-panel>
                </div>
            </div>
        </div>
    </main>
</x-layouts.app>
