@props(['block', 'lazyLoading' => false])

<section class="c-content component-border-radius component-white">
    <div class="container">
        <div class="row">
            <div class="col-12 {{ $block->data['sizing'] === 'narrow' ? 'offset-lg-2 col-lg-8' : '' }}">
                <div class="c-content__content">
                    @isset($block->data['content'])
                        {!! $block->data['content'] !!}
                    @endif

                    @isset($block->data['buttons'])
                        <nav class="buttons">
                            @foreach($block->data['buttons'] as $button)
                                <a href="{{ $button['url'] }}" class="button button--{{ $button['type'] ?? 'primary'}}">
                                    {{ $button['label'] }}
                                </a>
                            @endforeach
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
