@props(['block', 'lazyLoading' => false])

<section class="klantenservice component-border-radius component-white">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <figure class="klantenservice__banner mobile">
                    <img src="{{ Vite::asset('resources/images/placeholders/image-cta.jpg') }}" alt=""/>
                </figure>
            </div>
            <div class="col-12 col-lg-4">
                <aside class="klantenservice__sidebar">
                    <h2 class="title">Snel zelf regelen</h2>
                    <p>Waar kunnen wij jou mee helpen?</p>
                    <hr>
                    <address>
                        <div class="wrapper">
                            <div class="icon-wrapper">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20.001" height="14.262" viewBox="0 0 20.001 14.262">
                                    <g transform="translate(0.001 0.201)">
                                        <g transform="translate(0 14.061) rotate(-90)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                            <rect width="14" height="20" stroke="none"/>
                                            <rect x="0.75" y="0.75" width="12.5" height="18.5" fill="none"/>
                                        </g>
                                        <path d="M-8139.545-2542.061l8.818,6.831,8.82-6.831" transform="translate(8140.597 2542.911)" fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                    </g>
                                </svg>
                            </div>

                            <div class="contact-info">
                                <small>{{ __('Email') }}</small>
                                <p>{!! __('Send your question using email to :address and receive a reaction with one working day.', ['address' => '<a href="mailto:' . app(\Daylight\Core\Settings\General::class)->email . '">' . app(\Daylight\Core\Settings\General::class)->email . '</a>']) !!}</p>

                                <a href="mailto:{{ app(\Daylight\Core\Settings\General::class)->email }}" class="button--arrow">
                                    {{ __('Send email') }}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                        <g transform="translate(0.75 1.06)">
                                            <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="wrapper">
                            <div class="icon-wrapper">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="17.583" height="17.584" viewBox="0 0 17.583 17.584">
                                    <g id="Group_20642" data-name="Group 20642" clip-path="url(#clip-path)">
                                        <path id="Path_48147" data-name="Path 48147" d="M8.8,0A8.783,8.783,0,0,0,1.192,13.168L0,17.584,4.6,16.5a8.775,8.775,0,0,0,4.2,1.068h0A8.783,8.783,0,1,0,8.8,0m0,1.758a7.024,7.024,0,1,1-3.357,13.2l-.592-.323-.654.155-1.731.409.422-1.57.191-.7-.364-.632A7.024,7.024,0,0,1,8.8,1.758M5.694,4.726A.806.806,0,0,0,5.109,5a2.454,2.454,0,0,0-.769,1.829,4.27,4.27,0,0,0,.9,2.27A9,9,0,0,0,8.985,12.41c1.853.731,2.23.586,2.632.55A2.214,2.214,0,0,0,13.1,11.918a1.843,1.843,0,0,0,.129-1.044c-.055-.091-.2-.146-.421-.256s-1.3-.64-1.5-.713-.349-.11-.495.11-.565.713-.694.859-.256.167-.476.057A6.043,6.043,0,0,1,7.879,9.84,6.612,6.612,0,0,1,6.658,8.322c-.127-.219-.012-.339.1-.448s.218-.256.328-.385a1.527,1.527,0,0,0,.22-.366.406.406,0,0,0-.019-.385C7.23,6.628,6.8,5.545,6.608,5.11c-.164-.365-.338-.373-.495-.379-.127-.005-.273-.005-.419-.005" fill="#fff"/>
                                    </g>
                                </svg>
                            </div>

                            <div class="contact-info">
                                <small>{{ __('WhatsApp') }}</small>
                                <p>{!! __('We can also help you via :url. We`ll respond to your message as quickly as possible!', ['url' => '<a href="https://wa.me/' . app(\Daylight\Core\Settings\General::class)->phoneNumber . '" target="_blank" rel="nofollow">WhatsApp</a>']) !!}</p>

                                <a href="https://wa.me/{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}" target="_blank" rel="nofollow" class="button--arrow">
                                    {{ __('Send a message') }}

                                    <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                        <g transform="translate(0.75 1.06)">
                                            <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <div class="wrapper">
                            <div class="icon-wrapper">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="19" height="19" viewBox="0 0 19 19">
                                    <g transform="translate(0 0)">
                                        <g transform="translate(0 0)" clip-path="url(#a)">
                                            <path
                                                d="M17.652,15.416,14.1,11.868l-2.259,2.259a12.148,12.148,0,0,1-4.16-2.753,12.175,12.175,0,0,1-2.754-4.16L6.077,6.069a1.487,1.487,0,0,0,.083-2.145L3.645,1.409,1.634,3.415A3.106,3.106,0,0,0,.807,6.207a15.28,15.28,0,0,0,4.339,7.706,15.277,15.277,0,0,0,7.706,4.339,3.106,3.106,0,0,0,2.791-.826Z"
                                                transform="translate(-0.021 -0.038)" fill="none" stroke="#fff"
                                                stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                            <path d="M10.75,4.777A3.837,3.837,0,0,1,13.526,5.9"
                                                  transform="translate(-0.295 -0.131)" fill="none" stroke="#fff"
                                                  stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M16.275,3.039A7.79,7.79,0,0,0,10.749.75"
                                                  transform="translate(-0.295 -0.02)" fill="none" stroke="#fff"
                                                  stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M14.727,8.708A3.836,3.836,0,0,0,13.6,5.932"
                                                  transform="translate(-0.373 -0.162)" fill="none" stroke="#fff"
                                                  stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M16.431,3.1A7.792,7.792,0,0,1,18.72,8.63"
                                                  transform="translate(-0.451 -0.085)" fill="none" stroke="#fff"
                                                  stroke-linecap="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                            </div>
                            <div class="contact-info">
                                <small>Bellen</small>
                                <p>{!! __('Would you rather just call? You can reach us every weekday from 9:00 AM to 5:00 PM at :phone.', ['phone' => '<a href="tel:'.app(\Daylight\Core\Settings\General::class)->phoneNumber.'">'.app(\Daylight\Core\Settings\General::class)->phoneNumber.'</a>']) !!}</p>

                                <a href="tel:{{ app(\Daylight\Core\Settings\General::class)->phoneNumber }}" class="button--arrow">
                                    {{ __('Call us') }}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                        <g transform="translate(0.75 1.06)">
                                            <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                            <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </address>
                </aside>
            </div>

            <div class="col-12 col-lg-8">
                <figure class="klantenservice__banner desktop">
                    <img src="{{ Vite::asset('resources/images/placeholders/image-cta.jpg') }}" alt=""/>
                </figure>

                <div class="klantenservice__faq">
                    <h2 class="title">{{ __('Frequently asked questions') }}</h2>
                    <p>{{ __('Below you will find the answers to frequently asked questions.') }}</p>

                    @foreach($block->questionCategories->first()->questions as $question)
                        <x-cards.question
                            :question="$question"
                        />
                    @endforeach

                    @isset($block->data['faq'])
                        <a href="{{ $block->data['faq']['url'] }}" class="button--arrow">
                            {{ $block->data['faq']['label'] }}
                            <svg xmlns="http://www.w3.org/2000/svg" width="10.59" height="9.645" viewBox="0 0 10.59 9.645">
                                <g transform="translate(0.75 1.06)">
                                    <path d="M-14369.2-5007.5h9.09" transform="translate(14369.203 5011.262)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-width="1.5"/>
                                    <path d="M-14359.936-5008.41l3.762-3.762-3.762-3.761" transform="translate(14365.264 5015.934)" fill="none" stroke="#ff8126" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                </g>
                            </svg>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
