@props(['block', 'lazyLoading' => false])

@if($images = $block->media->where('pivot.properties.field', 'images'))
    <section class="gallery-3-images component-border-radius component-white">
        <div class="container">
            <div class="row">
                <div class="col-12 offset-lg-1 col-lg-10">
                    <div class="gallery-3-images__grid">
                        @foreach($images as $image)
                            <img
                                src="{{ $image->getUrl() }}"
                                alt="{{ $component->data['title'] ?? '' }}"
                                loading="{{ $lazyLoading ? 'lazy': 'eager' }}"
                                fetchpriority="{{ $lazyLoading ? 'low': 'high' }}"
                            >
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif
