<div class="price-facet" x-data="rangeSlider()" x-init="init()" wire:ignore wire:key="{{ $facet->property }}">
    <div class="price-facet__slider">
        <input class="price-facet__input" type="range" step="1" :min="initialMinimum" :max="initialMaximum" @input="onChangeMinimumTrigger();" x-model.number="selectedMinimum" @change="maybeUpdate">
        <input class="price-facet__input" type="range" step="1" :min="initialMinimum" :max="initialMaximum" @input="onChangeMaximumTrigger()" x-model.number="selectedMaximum" @change="maybeUpdate">

        <div class="price-facet__bar">
            <div class="price-facet__bar-background"></div>
            <div class="price-facet__bar-active" :style="'right:'+(calculatedOffsetRight >= 100 ? 100 : calculatedOffsetRight)+'%; left:'+(calculatedOffsetLeft <= 0 ? 0 : calculatedOffsetLeft)+'%'"></div>
            <div class="price-facet__handle price-facet__handle--left" :style="'left: '+(calculatedOffsetLeft <= 0 ? 0 : calculatedOffsetLeft)+'%'"></div>
            <div class="price-facet__handle price-facet__handle--right" :style="'right: '+(calculatedOffsetRight >= 100 ? 100 : calculatedOffsetRight)+'%'"></div>
        </div>
    </div>

    <div class="price-facet__form">
        <input type="number" step="1" x-model.number="selectedMinimum" :min="0" :name="shouldActivateFilters ? 'filters[price][min]' : ''" @change="onChangeMinimumTrigger(); selectFilters()">
        <input type="number" step="1" x-model.number="selectedMaximum" :max="initialMaximum" :name="shouldActivateFilters ? 'filters[price][max]' : ''" @change="onChangeMaximumTrigger(); selectFilters()">
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('rangeSlider', (uniqueId) => ({
                initialMinimum: {{ floor($facet->range['min']) }},
                initialMaximum: {{ floor($facet->range['max']) }},
                selectedMinimum: {{ floor($activeRange->originalValues['min'] ?? $facet->range['min']) }},
                selectedMaximum: {{ floor($activeRange->originalValues['max'] ?? $facet->range['max']) }},
                calculatedOffsetLeft: 0,
                calculatedOffsetRight: 0,

                init() {
                    this.onChangeMinimumTrigger();
                    this.onChangeMaximumTrigger();

                    {{--Livewire.hook('message.processed', (message, component) => {--}}
                    {{--    this.selectedMinimum = {{ floor($facet->range['min']) }};--}}
                    {{--    this.selectedMaximum = {{ floor($facet->range['max']) }};--}}

                    {{--    this.onChangeMinimumTrigger();--}}
                    {{--    this.onChangeMaximumTrigger();--}}
                    {{--});--}}
                },

                maybeUpdate() {
                    this.selectFilters(false);
                },

                onChangeMinimumTrigger() {
                    this.selectedMinimum = Math.min(this.selectedMinimum, this.selectedMaximum);
                    this.calculatedOffsetLeft = ((this.selectedMinimum - this.initialMinimum) / (this.initialMaximum - this.initialMinimum)) * 100;
                },

                onChangeMaximumTrigger() {
                    if (this.selectedMaximum < this.selectedMinimum) {
                        this.selectedMaximum = this.selectedMinimum;
                    }

                    this.calculatedOffsetRight = 100 - (((this.selectedMaximum - this.initialMinimum) / (this.initialMaximum - this.initialMinimum)) * 100);


                    // this.selectedMaximum = Math.max(this.selectedMaximum, this.selectedMinimum);
                    // this.selectedMaximum = Math.max(this.selectedMaximum, this.selectedMinimum);
                    // this.calculatedOffsetRight = 100 - (((this.selectedMaximum - this.initialMinimum) / (this.initialMaximum - this.initialMinimum)) * 100);
                },

                formatCurrency(value) {
                    return new Intl.NumberFormat(this.locale, {
                        style: 'currency',
                        currency: 'EUR',
                        maximumFractionDigits: 0
                    }).format(value);
                },

                selectFilters(withDebounce = true) {
                    if(!withDebounce) {
                        if (this.shouldActivateFilters) {
                            this.$wire.set('filters.price.min', this.selectedMinimum);
                            this.$wire.set('filters.price.max', this.selectedMaximum);
                        }
                        return;
                    }

                    this.debounce(() => {
                        if (this.shouldActivateFilters) {
                            this.$wire.set('filters.price.min', this.selectedMinimum);
                            this.$wire.set('filters.price.max', this.selectedMaximum);
                        }
                    })();
                },

                shouldActivateFilters() {
                    return this.selectedMinimum !== this.initialMinimum || this.selectedMaximum !== this.initialMaximum;
                },

                debounce(func, wait = 250) {
                    let timeout;
                    return function (...args) {
                        clearTimeout(timeout);
                        timeout = setTimeout(() => func.apply(this, args), wait);
                    };
                }
            }));
        });
    </script>
</div>


