<section class="faq-archive component-border-radius component-white" x-data="{ activeCategory: null }">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav class="faq-archive__filters" aria-label="FAQ categories">
                    <ul class="filter-list">
                        <li>
                            <button
                                class="filter"
                                :class="{ 'active': activeCategory === null }"
                                @click.prevent="activeCategory = null"
                            >
                                {{ __('View all') }}
                            </button>
                        </li>
                        @foreach($questionCategories->filter(fn($q) => $q->questions->isNotEmpty()) as $category)
                            <li>
                                <button
                                    class="filter"
                                    @click.prevent="activeCategory = {{ $category->id }}"
                                    :class="{ 'active': activeCategory === {{ $category->id }} }"
                                >
                                    {{ $category->name }}
                                </button>
                            </li>
                        @endforeach
                    </ul>
                </nav>
                <div class="col-12">
                    <hr class="faq-archive__divider">
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    @foreach($questionCategories->filter(fn($q) => $q->questions->isNotEmpty()) as $category)
                        <div class="faq-archive__section" x-show="activeCategory === null || activeCategory === {{ $category->id }}">
                            <h2 class="title">{{ $category->name }}</h2>

                            <div class="wrapper">
                                @foreach($category->questions->chunk(2) as $questions)
                                    <div class="{{ $loop->even ? 'column-even' : 'column-odd' }}">
                                        @foreach($questions as $question)
                                            <x-cards.question :question="$question" />
                                        @endforeach
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
