@extends('daylight::layouts.app')

@section('title', __('Edit :questionCategory', ['questionCategory' => $questionCategory->name]))

@section('content')
    <div x-data="{ showConfirmDeleteModal: false }">
        <x-daylight::page-header :title="__('Edit :questionCategory', ['questionCategory' => $questionCategory->name])">
            @can('delete:pages')
                <x-daylight::buttons.danger @click.prevent="showConfirmDeleteModal = true">
                    {{ __('Delete question category') }}
                </x-daylight::buttons.danger>
            @endif
        </x-daylight::page-header>

        <x-daylight::session-messages/>

        <form method="post" action="{{ route('daylight.content.question-categories.update', $questionCategory) }}">
            @csrf
            @method('PUT')
            <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

            <x-daylight::locale-selector :route="route('daylight.content.question-categories.edit', $questionCategory)"/>

            <x-daylight::input.group
                :label="__('Name')"
                :error="$errors->first('name')"
                for="name"
            >
                <x-daylight::input.text name="name" id="name" value="{{ old('name', $questionCategory->name) }}" />
            </x-daylight::input.group>

            <div class="mt-6 flex items-center justify-end gap-x-3">
                <x-daylight::buttons.secondary href="{{ route('daylight.content.question-categories.index') }}" element="a">
                    {{ __('Cancel') }}
                </x-daylight::buttons.secondary>

                <x-daylight::buttons.primary type="submit">
                    {{ __('Save') }}
                </x-daylight::buttons.primary>
            </div>
        </form>

        <x-daylight::modal.confirm-delete-modal>
            <x-slot name="content">
                <h3 class="text-base font-semibold leading-6 text-gray-900" id="modal-title">{{ __('Delete :object', ['object' => __('question category')]) }}</h3>
                <div class="mt-2">
                    <p class="text-sm text-gray-500">
                        {{ __('Are you sure you want to delete this :object? This action cannot be undone.', ['object' => __('question category')]) }}
                    </p>
                </div>
            </x-slot>

            <x-slot name="footer">
                <form method="post" action="{{ route('daylight.content.question-categories.destroy', $questionCategory) }}">
                    @csrf
                    @method('DELETE')

                    <button type="button" class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-100 sm:mt-0 sm:w-auto" @click.prevent="showConfirmDeleteModal = false">
                        {{ __('Cancel') }}
                    </button>

                    <button type="submit" class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-2 sm:w-auto">
                        {{ __('Delete') }}
                    </button>
                </form>
            </x-slot>
        </x-daylight::modal.confirm-delete-modal>
    </div>
@endsection
