@extends('daylight::layouts.app')

@section('title', __('Create new testimonial'))

@section('content')
    <x-daylight::page-header :title="__('Create new testimonial')"/>

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.content.testimonials.store') }}"
          x-data="{ name: '{{ old('name') }}'}">
        @csrf

        <x-daylight::input.group
            :label="__('Locale')"
            :error="$errors->first('locale')"
            for="locale"
        >
            <x-daylight::input.select name="locale" id="locale">
                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                    <option value="{{ $locale }}" {{ old('locale') === $locale ? 'selected' : '' }}>
                        {{ strtoupper($locale) }}
                    </option>
                @endforeach
            </x-daylight::input.select>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            for="name"
        >
            <x-daylight::input.text name="name" id="name" value="{{ old('name') }}"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Company')"
            :error="$errors->first('company')"
            for="company"
        >
            <x-daylight::input.text name="company" id="company" value="{{ old('company') }}"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Location')"
            :error="$errors->first('location')"
            for="location"
        >
            <x-daylight::input.text name="location" id="location" value="{{ old('location') }}"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Rating')"
            :error="$errors->first('rating')"
            for="rating"
        >
            <x-daylight::input.text type="number" min="1" max="5" step="1" name="rating" id="rating" value="{{ old('rating') }}"/>
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Title')"
            :error="$errors->first('title')"
            for="title"
        >
            <x-daylight::input.text name="title" id="title" value="{{ old('title') }}" />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('Content')"
            :error="$errors->first('content')"
            for="content"
        >
            <x-daylight::input.textarea name="content" id="content">{{ old('content') }}</x-daylight::input.textarea>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.testimonials.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
