<div>
    <div class="product-single__add-to-cart add-to-cart {{ $variant->stock === 0 ? 'not-active' : '' }}">
        @isset($variant)
            <form x-data="{ quantity: $wire.entangle('quantity') }">
                <div class="quantity quantity--large">
                    <button @click.prevent="quantity > 1 ? quantity-- : ''" :disabled="quantity <= 1"
                            class="quantity__decrement" {{ $disabled ? 'disabled' : '' }}>
                        <svg xmlns="http://www.w3.org/2000/svg" width="8" height="1.2" viewBox="0 0 8 1.2">
                            <path id="Path_8960" data-name="Path 8960" d="M-8881.847-5930.119h8"
                                  transform="translate(8881.847 5930.719)" fill="none" stroke="#171716"
                                  stroke-width="1.2"/>
                        </svg>
                    </button>

                    <input type="number" value="1" wire:model="quantity" min="1"
                           class="quantity__input" {{ $disabled ? 'disabled' : '' }}>

                    <button @click.prevent="quantity++" class="quantity__increment" {{ $disabled ? 'disabled' : '' }}>
                        <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 8 8">
                            <g id="Group_18870" data-name="Group 18870" transform="translate(-1467 -259)">
                                <path id="Path_8960" data-name="Path 8960" d="M-8881.847-5930.119h8"
                                      transform="translate(10348.847 6193.119)" fill="none" stroke="#171716"
                                      stroke-width="1.2"/>
                                <path id="Path_36621" data-name="Path 36621" d="M-8881.847-5930.119h8"
                                      transform="translate(7401.119 -8614.847) rotate(-90)" fill="none" stroke="#171716"
                                      stroke-width="1.2"/>
                            </g>
                        </svg>
                    </button>
                </div>
            </form>

            <button
                class="button button--primary button--cart"
                wire:loading.attr="disabled"
                wire:click.prevent="addToCart" {{ !$variant->inStock() ? 'disabled' : '' }}
                {{ $disabled ? 'disabled' : '' }}
            >
                <span wire:loading.remove> {{ __('Add to cart') }}</span>
                <span wire:loading>{{ __('Loading..') }}</span>
            </button>
        @endif

        @script
        <script>
            $wire.on('add-to-cart', (event) => {
                dataLayer.push({ecommerce: null});

                dataLayer.push({
                    event: 'add_to_cart',
                    ecommerce: {
                        items: event
                    }
                });
            });
        </script>
        @endscript
    </div>
</div>
